from fastapi import APIRouter, Depends, HTTPException
from app.db import database
from app.v1.models.platform.subscription import SubscriptionSettings
from app.v1.services.platform import subscription as subscription_service

router = APIRouter()

@router.get("/", response_model=SubscriptionSettings)
def get_settings(db: database.MongoDB = Depends(database.get_mongo_db)):
    try:
        return subscription_service.get_subscription_settings(db)
    except Exception as e:
        raise HTTPException(status_code=500, detail=str(e))

@router.post("/{account_id}", response_model=SubscriptionSettings)
def update_settings(account_id: str, settings: SubscriptionSettings, db: database.MongoDB = Depends(database.get_mongo_db)):
    try:
        return subscription_service.update_subscription_settings(account_id, settings.dict(), db)
    except Exception as e:
        raise HTTPException(status_code=500, detail=str(e))
